<?php include_once('header.php'); ?>

    <div class="container">
      <div class="card-deck mb-3 text-center">
        <div class="d-flex justify-content-between flex-wrap flex-md-nowrap mt-3 align-items-center pb-2 mb-3 border-bottom" style="width: 100%;">
            <h1 class="h2">Add New Vacancy</h1>

            <div class="btn-toolbar mb-2 mb-md-0">
              <div class="btn-group mr-2">     
                <a class="btn btn-sm btn-outline-secondary" href="vacancies.php">Vacancies</a>    
              </div>
            </div>
          </div>

          <div id="error"></div>
          <?php include_once('sql_statements.php'); ?>
          <!-- new vacancy section -->
          <div id="new-vacancy" style="width: 100%">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap mt-3 pb-2 mb-3 border-bottom" style="width: 100%; text-align: left;">
              <div class="col-md-12 order-md-1">

                <form  id="new_job" method="post" action="">
                  <input type="hidden" name="add_vacancy">
                  <div class="row">

                    <div class="col-md-6 mb-4">
                      <label for="firstName">Job Type</label>
                       <select class="form-control" name="category" id="category">
                         <option value="">Choose</option>
                         <option value="Volunteers">Volunteers</option>
                         <option value="Internship">Internship</option>
                         <option value="PartTime">PartTime</option>
                         <option value="Full Time">Full Time</option>
                      </select>
                    </div>

                    <div class="col-md-6 mb-4">
                      <label for="Password">Closing Date</label>
                      <input type="date" class="form-control" name="closing_date" 
                            value="<?php if(isset($_POST['closing_date'])){echo $_POST['closing_date'];} ?>">

                    </div>

                  </div>
                  <div class="row">


                    <div class="col-md-12 mb-3">
                      <label for="Password">Job Title</label>
                      <input type="text" class="form-control" name="job_title" value="<?php if(isset($_POST['job_title'])){echo $_POST['job_title'];}?>">

                    </div>
                  </div>

                  <div class="row">
                    <div class="col-md-12 mb-3">
                      <label for="Password">Job Details</label><br>
                      <textarea class="form-control" name="job_details" id="textbox" rows="9"><?php if(isset($_POST['job_details'])){echo $_POST['job_details'];}?></textarea>
                    </div>
                  </div>

                  <button class="btn btn-primary btn-md" type="reset" name="reset" id="reset" style="float: right;">
                     Clear Form
                  </button>
                  <button class="btn btn-primary btn-md" type="submit" name="create_vacancy" id="create_vacancy" style="float: right; margin-right: 5px;">
                     Create Vacancy
                  </button>
                </form>
              </div>
          </div>

          </div>
          <!-- end new user form -->
      </div>

    </div>


    <!-- Bootstrap core JavaScript
    ================================================== -->
    <!-- Placed at the end of the document so the pages load faster -->
    <script src="https://code.jquery.com/jquery-3.2.1.slim.min.js" integrity="sha384-KJ3o2DKtIkvYIK3UENzmM7KCkRr/rE9/Qpg6aAZGJwFDMVNA/GpGFF93hXpG5KkN" crossorigin="anonymous"></script>
    <script src="../../js/vendor/popper.min.js"></script>
    <script src="../../js/bootstrap.min.js"></script>
    <script src="../../js/vendor/holder.min.js"></script>
    <script type="text/javascript" src="../../js/jquery-3.2.1.min.js"></script>
    <script type="text/javascript" src="../../js/validation.min.js"></script>
    <script src="../../js/tables/jquery.dataTables.js"></script>
    <script src="../../js/tables/dataTables.bootstrap4.js"></script>

     <!--  summernote JS
        ============================================ -->
    <script src="../../js/summernote/summernote-updated.min.js"></script>
    <script src="../../js/summernote/summernote-active.js"></script>

    <script>
      $(document).ready(function(){

        //adds a new vacancy
        /* validation */
   $("#new_jo").validate({
      rules:
    {
      job_title: {required: true},
      location: {required: true},
     },
       messages:
     {
        job_title:{required: "Please enter job title"},
        location: "Please enter your location"
       },
     submitHandler: submitForm
       });
     /* validation */

     /* login submit */
     function submitForm()
     {
      //var data = $("#new_job").serialize();
      var formData = $("#new_jo").submit(function () {
          return;
      });
      var formData = new FormData(formData[0]);

      $.ajax({

      type : 'POST',
      url  : 'sql_statements.php',
      data : formData,
      beforeSend: function()
      {
        $("#error").fadeOut();
        $("#create_vacancy").html('<i class="fa fa-spin fa-spinner"></i> Checking ...');
      },
      success :  function(response)
         {  alert(response);
          if(response == 3){
            $("#create_vacancy").html('<i class="fa fa-spin fa-spinner"></i> &nbsp; Signing In ...');
            setTimeout(' window.location.href = "user_accounts/editors/dashboard.php"; ',2000);
          }
          else if(response == 4){
            $("#error").fadeIn(2000, function(){
              $("#error").html('<div class="alert alert-error"> <button type="button" class="close" data-dismiss="alert">×</button><span class="icon icon-user"></span> Your username/password combination is invalid!</div>');
            $("#login").html('<span class="fa fa-sign-in"></span> &nbsp; Sign In');
                  });//Your username/password entered doesn't match
            $("#error").fadeOut(5000,function(){});
          }
          else if(response == 5){
            $("#error").fadeIn(2000, function(){
              $("#error").html('<div class="alert alert-error"> <button type="button" class="close" data-dismiss="alert">×</button><span class="icon icon-lock"></span> Your account has been locked, contact the Systems Administrator to help you unlock the account!</div>');
            $("#login").html('<span class="fa fa-lock"></span> &nbsp; Account Locked');
                  });//Your username/password entered doesn't match
            $("#error").fadeOut(180000,function(){});
          }

        },
                contentType: false,
                processData: false,
                cache: false
      });
        return false;
    }
     /*end add vacancy script */


      });

      //delete vacancy details details
      $(document).on('click', '.btn_delete', function(){
             var id=$(this).data("id3");
             var delete_vacancy="delete_vacancy";
             //alert(user+" "+id);
             if(confirm("Are you sure you want to remove this Vacancy?"+id))
             {
                  $.ajax({
                       url:"sql_statements.php",
                       method:"POST",
                       data:{vacancy_id:id, delete_vacancy:delete_vacancy},
                       dataType:"text",
                       success:function(data){
                            //alert(data);
                          if(data == 1){
                              $("#error").fadeIn(2000, function(){
                              $("#error").html('<div class="alert alert-success"> <button type="button" class="close" data-dismiss="alert">×</button><span class="icon icon-ok-circle"></span>&nbsp; A vacancy has been removed!</div>');
                                  });//Your username/password entered doesn't match
                            $("#error").fadeOut(5000,function(){});
                            }
                            fetchData();
                       }
                  });
             }
        });

      //show vacancy details
      $(document).on('click', '.show_btn', function(){
             var id=$(this).data("id3");
             var show_vacancy="show_vacancy";

             //alert(id);

            $.ajax({
                   url:"sql_statements.php",
                   method:"POST",
                   data:{vacancy_id:id, show_vacancy:show_vacancy},
                   dataType:"text",
                   success:function(data){
                        //alert(data);
                      if(data == 1){
                          $("#error").fadeIn(2000, function(){
                          $("#error").html('<div class="alert alert-success"> <button type="button" class="close" data-dismiss="alert">×</button><span class="icon icon-ok-circle"></span>&nbsp; A vacancy can now be accessed by the public!</div>');
                              });//Your username/password entered doesn't match
                        $("#error").fadeOut(5000,function(){});
                        }
                        fetchData();
                   }
              });

        });

      //show vacancy details
      $(document).on('click', '.hide_btn', function(){
             var id=$(this).data("id3");
             var hide_vacancy="hide_vacancy";

             alert(id);

            $.ajax({
                   url:"sql_statements.php",
                   method:"POST",
                   data:{vacancy_id:id, hide_vacancy:hide_vacancy},
                   dataType:"text",
                   success:function(data){
                      alert(data);
                      if(data == 1){
                          $("#error").fadeIn(2000, function(){
                          $("#error").html('<div class="alert alert-success"> <button type="button" class="close" data-dismiss="alert">×</button><span class="icon icon-ok-circle"></span>&nbsp; A vacancy has been hidden from the public/expired!</div>');
                              });//Your username/password entered doesn't match
                        $("#error").fadeOut(5000,function(){});
                        }
                        fetchData();
                   }
              });

        });

      Holder.addTheme('thumb', {
        bg: '#55595c',
        fg: '#eceeef',
        text: 'Thumbnail'
      });

    </script>
  </body>
</html>
