<?php include_once('header.php'); ?>

<div class="container">
    <div class="card-deck mb-3 text-center">
        <div class="d-flex justify-content-between flex-wrap flex-md-nowrap mt-3 align-items-center pb-2 mb-3 border-bottom" style="width: 100%;">
            <h1 class="h2">Added Herbicides</h1>

            <div class="btn-toolbar mb-2 mb-md-0">
                <div class="btn-group mr-2">
                    <a class="btn btn-sm btn-outline-secondary" href="create-herbicides.php">Add New Herbicides</a>
                </div>
            </div>
        </div>

        <div id="error" style="width: 100%; text-align: left;"></div>


        <div class="table-responsive">
            <div id="live_data" style="width: 100%; text-align: left;"></div>
        </div>
    </div>

</div>


<!-- Bootstrap core JavaScript
    ================================================== -->
<!-- Placed at the end of the document so the pages load faster -->
<script src="https://code.jquery.com/jquery-3.2.1.slim.min.js" integrity="sha384-KJ3o2DKtIkvYIK3UENzmM7KCkRr/rE9/Qpg6aAZGJwFDMVNA/GpGFF93hXpG5KkN" crossorigin="anonymous"></script>
<script>
    window.jQuery || document.write('<script src="../../js/vendor/jquery-slim.min.js"><\/script>')
</script>
<script src="../../js/vendor/popper.min.js"></script>
<script src="../../js/bootstrap.min.js"></script>
<script src="../../js/vendor/holder.min.js"></script>
<script type="text/javascript" src="../../js/jquery-3.2.1.min.js"></script>
<script type="text/javascript" src="../../js/validation.min.js"></script>
<script src="../../js/tables/jquery.dataTables.js"></script>
<script src="../../js/tables/dataTables.bootstrap4.js"></script>

<!--  summernote JS
        ============================================ -->
<script src="../../js/summernote/summernote-updated.min.js"></script>
<script src="../../js/summernote/summernote-active.js"></script>

<script>
    function fetchData() {
        $.ajax({
            url: "select-herbicides.php",
            method: "POST",
            success: function(data) {
                $('#live_data').html(data);
            }
        });
    }
    $(document).ready(function() {

        //loads system users
        $.ajax({
            url: "select-herbicides.php",
            method: "POST",
            success: function(data) {
                $('#live_data').html(data);
            }
        });



        $('#new-vacancy').hide(); //hide new user form on page load
        //when a new user button has been clicked
        $('#new_vacancy').click(function() {
            $("#new-vacancy").show();
            $("#hide").click(function() {
                $("#new-vacancy").hide();
            })
        });

        //});

        //adds a new vacancy
        /* validation */
        $("#new_job").validate({
            rules: {
                job_title: {
                    required: true
                },
                location: {
                    required: true
                },
            },
            messages: {
                job_title: {
                    required: "Please enter job title"
                },
                location: "Please enter your location",
            },
            submitHandler: submitForm
        });
        /* validation */

        /* login submit */
        function submitForm() {
            var data = $("#new_job").serialize();

            $.ajax({

                type: 'POST',
                url: 'sql_statements.php',
                data: data,
                beforeSend: function() {
                    $("#error").fadeOut();
                    $("#create_vacancy").html('<i class="fa fa-spin fa-spinner"></i> Checking ...');
                },
                success: function(response) { //alert(response);
                    if (response == 3) {
                        $("#create_vacancy").html('<i class="fa fa-spin fa-spinner"></i> &nbsp; Signing In ...');
                        setTimeout(' window.location.href = "user_accounts/editors/dashboard.php"; ', 2000);
                    } else if (response == 4) {
                        $("#error").fadeIn(2000, function() {
                            $("#error").html('<div class="alert alert-error"> <button type="button" class="close" data-dismiss="alert">×</button><span class="icon icon-user"></span> Your username/password combination is invalid!</div>');
                            $("#login").html('<span class="fa fa-sign-in"></span> &nbsp; Sign In');
                        }); //Your username/password entered doesn't match
                        $("#error").fadeOut(5000, function() {});
                    } else if (response == 5) {
                        $("#error").fadeIn(2000, function() {
                            $("#error").html('<div class="alert alert-error"> <button type="button" class="close" data-dismiss="alert">×</button><span class="icon icon-lock"></span> Your account has been locked, contact the Systems Administrator to help you unlock the account!</div>');
                            $("#login").html('<span class="fa fa-lock"></span> &nbsp; Account Locked');
                        }); //Your username/password entered doesn't match
                        $("#error").fadeOut(180000, function() {});
                    }

                }
            });
            return false;
        }
        /*end add vacancy script */


    });

    //delete vacancy details details
    $(document).on('click', '.btn_delete', function() {
        var id = $(this).data("id3");
        var action = "delete_herbicide";
        //alert(user+" "+id);
        if (confirm("Are you sure you want to remove this service?")) {
            $.ajax({
                url: "sql_statements.php",
                method: "POST",
                data: {
                    id: id,
                    action: action
                },
                dataType: "text",
                success: function(data) {
                    alert(data);
                    if (data == 1) {
                        $("#error").fadeIn(1000, function() {
                            $("#error").html('<div class="alert alert-success"> <button type="button" class="close" data-dismiss="alert">×</button><span class="icon icon-ok-circle"></span>&nbsp; A service has been deleted successfully!</div>');
                        });
                        $("#error").delay(6000).fadeOut(function() {});
                    }
                    fetchData();
                }
            });
        }
    });

    //show vacancy details
    $(document).on('click', '.show_btn', function() {
        var id = $(this).data("id3");
        var action = "show_herbicide";

        //alert(id);

        $.ajax({
            url: "sql_statements.php",
            method: "POST",
            data: {
                id: id,
                action: action
            },
            dataType: "text",
            success: function(data) {
                //alert(data);
                if (data == 1) {
                    $("#error").fadeIn(2000, function() {
                        $("#error").html('<div class="alert alert-success"> <button type="button" class="close" data-dismiss="alert">×</button><span class="icon icon-ok-circle"></span>&nbsp; A service can now be accessed by the public!</div>');
                    }); //Your username/password entered doesn't match
                    $("#error").fadeOut(5000, function() {});
                }
                fetchData();
            }
        });

    });

    //show vacancy details
    $(document).on('click', '.hide_btn', function() {
        var id = $(this).data("id3");
        var action = "hide_herbicide";

        //alert(id);

        $.ajax({
            url: "sql_statements.php",
            method: "POST",
            data: {
                id: id,
                action: action
            },
            dataType: "text",
            success: function(data) {
                //alert(data);
                if (data == 1) {
                    $("#error").fadeIn(2000, function() {
                        $("#error").html('<div class="alert alert-success"> <button type="button" class="close" data-dismiss="alert">×</button><span class="icon icon-ok-circle"></span>&nbsp; A service has been hidden from the public!</div>');
                    }); //Your username/password entered doesn't match
                    $("#error").fadeOut(5000, function() {});
                }
                fetchData();
            }
        });

    });

    Holder.addTheme('thumb', {
        bg: '#55595c',
        fg: '#eceeef',
        text: 'Thumbnail'
    });
</script>
</body>

</html>